	//
	//	DumpControlHierarchy FKEY,  1997 Apple Computer, Inc.
	//	Complaints and kudos to Pete Gontier <devsupport@apple.com>
	//
	//	WHAT IS IT?
	//	===========
	//
	//	It's a very simple diagnostic tool for developers using the
	//	control hierarchy facilities in Appearance. It asks the user
	//	to save a file, and then writes a profile of the control
	//	hierarchy in the frontmost window to that file.
	//
	//	HOW DO I RUN IT?
	//	================
	//
	//	It's an FKEY, not to be confused with the function keys
	//	appearing in a row across the top of some keyboards (F1,
	//	F2, etc.). FKEYs are documented (a bit) in Inside Macintosh:
	//	Macintosh Toolbox Essentials on page 2-39. What's not
	//	documented is how to install them. During GetNextEvent,
	//	if an appropriate key sequence is detected, Event Manager
	//	calls GetResource to obtain the FKEY resource. GetResource
	//	searches the current chain of resource maps, including that
	//	of the current application and the System File. So you can
	//	install an FKEY anywhere in the current resource map chain.
	//	Just copy and paste the FKEY resource with Resorcerer (or
	//	ResEdit if you must...). Usually FKEYs are installed in the
	//	System file. Unfortunately, nothing arbitrates the resource
	//	IDs of FKEYs, so be careful.
	//
	//	LEGAL NOTICE
	//	============
	//
	// 	You may incorporate this sample code into your applications
	// 	without restriction. This sample code has been provided "AS
	// 	IS" and the responsibility for its operation is 100% yours.
	// 	You are not permitted to redistribute the source as "Apple
	// 	sample code" after having made changes. If you're going to
	// 	re-distribute the source, we require that you make it clear
	// 	in the source that the code was descended from Apple sample
	// 	code, but that you've made changes.
	//

#define OLDROUTINELOCATIONS		0
#define OLDROUTINENAMES			0
#define SystemSevenOrLater		1

#ifndef __APPEARANCE__
#	include "Appearance.h"
#endif

#ifndef __STANDARDFILE__
#	include <StandardFile.h>
#endif

#ifndef __A4STUFF__
#	include <A4Stuff.h>
#endif

void pascal main (void)
{
	WindowPtr frontWindow = FrontWindow ( );

	if (!frontWindow)
		SysBeep (-1);
	else
	{
		long preservedA4 = SetCurrentA4 ( );

		StandardFileReply sfr;

		StandardPutFile ("\pDump control hierarchy as:", "\pcontrol hierarchy dump", &sfr);

		if (sfr.sfGood && (DumpControlHierarchy (frontWindow, &(sfr.sfFile))))
			SysBeep (-1);

		SetA4 (preservedA4);
	}
}
